# BedrockIfy
BedrockIfy is a fabric Minecraft Mod that implements some useful Minecraft Bedrock Edition features into Minecraft Java Edition.

## Features
- Bedrock-like loading screens with helpful tips.
- Third person eating animations.
- Position and "paper doll" overlay.
- Saving status overlay.
- Bedrock Crafting Recipes (Toggleable).
- Bedrock-like chat.
- Bedrock Edition world color noise for grass and water.
- Idle hand animations.
- Held item descriptions (enchantments, books and potions).
- Reach-around block placement.
- Quick armor swap.
- Dying and Fallen Trees!
- Bedrock Light block shading.
- Disable flying momentum (Drift) in creative mode.
- Stop elytra flying by pressing space on air.

Bedrockify also includes "eye-candy" features like the ability use the rotating title screen background in all option screens instead of the boring vanilla dirt background.
All Features are customizable through the In-Game BedrockIfy Settings Menu!
#### ScreenShots:
![HUD](https://github.com/juancarloscp52/BedrockIfy/blob/master/readme%20images/HUD.png)
![Loading Screen](https://github.com/juancarloscp52/BedrockIfy/blob/master/readme%20images/loading%20screen.png)
![Reach-around block placement](https://github.com/juancarloscp52/BedrockIfy/blob/master/readme%20images/reacharound.gif)
![Rotating background on all screens](https://github.com/juancarloscp52/BedrockIfy/blob/master/readme%20images/menu.gif)

## Installation:
This mod requires [Fabric](https://fabricmc.net/use/) and [Fabric API](https://www.curseforge.com/minecraft/mc-mods/fabric-api), or [Quilt](https://quiltmc.org/install/) with the [Quilted Fabric API](https://modrinth.com/mod/qsl) 
You can download BedrockIfy from the _[releases](https://github.com/juancarloscp52/BedrockIfy/releases)_ tab in GitHub, through the [CurseForge](https://www.curseforge.com/minecraft/mc-mods/bedrockify) page or [Modrinth](https://modrinth.com/mod/bedrockify).
Drop BedrockIfy and Fabric API JARs inside the mods folder.
## Building from source:
Under Linux / Mac OS
```shell script
git clone https://github.com/juancarloscp52/BedrockIfy/
cd BedrockIfy
./gradlew build
```
Under Windows
```shell script
git clone https://github.com/juancarloscp52/BedrockIfy/
cd BedrockIfy
gradlew build
```
You can find the built JARs inside BedrockIfy/build/libs

## Enhancing your Bedrock-like experience

Here is a list of other Fabric Mods that can improve your BedrockLike Experience: (Note: some of these might not be updated to the latest version.)
- [MidnightControls](https://github.com/TeamMidnightDust/MidnightControls) - Enables Controller support and other useful tweaks.
- [Sheep Consistency](https://github.com/IMS212/sheepconsistency) Let's you see the color of sheared sheep.
- [BedrockWaters](https://github.com/2Retr0/BedrockWaters) - Ports all Bedrock Edition biome specific water color.
- [Snowy Leaves](https://github.com/Ashley1227/snowy-leaves) - Leaves will turn white while snowing.
- [Fade In Chunks](https://github.com/johni0702/fade-in-chunks) Adds a Bedrock Edition style fading in animation for newly loaded chunks.

If you wish to have bedrock's unique textures/models you can check out the Parity section of [VanillaTweaks](https://vanillatweaks.net/picker/resource-packs/)

## License
Bedrockify is released under the free and open-source [GPL-3.0 License](https://github.com/juancarloscp52/BedrockIfy/blob/master/LICENSE).
